import { NextResponse } from 'next/server';
import { openDB } from '@/src/lib/db';
import { DashboardStats } from '@/src/types/customer';

export async function GET() {
  try {
    const db = await openDB();

    // Get basic counts
    const totalCustomers = await new Promise<{ count: number }>((resolve, reject) => {
      db.get('SELECT COUNT(*) as count FROM customers', (err, row) => {
        if (err) reject(err); else resolve(row as { count: number });
      });
    });

    const totalDomains = await new Promise<{ count: number }>((resolve, reject) => {
      db.get('SELECT COUNT(*) as count FROM domains', (err, row) => {
        if (err) reject(err); else resolve(row as { count: number });
      });
    });

    const activeCustomers = await new Promise<{ count: number }>((resolve, reject) => {
      db.get('SELECT COUNT(*) as count FROM customers WHERE status = "active"', (err, row) => {
        if (err) reject(err); else resolve(row as { count: number });
      });
    });

    const leadCustomers = await new Promise<{ count: number }>((resolve, reject) => {
      db.get('SELECT COUNT(*) as count FROM customers WHERE status = "lead"', (err, row) => {
        if (err) reject(err); else resolve(row as { count: number });
      });
    });

    const salesReps = await new Promise<{ count: number }>((resolve, reject) => {
      db.get('SELECT COUNT(DISTINCT assigned_sales_rep) as count FROM customers WHERE assigned_sales_rep IS NOT NULL', (err, row) => {
        if (err) reject(err); else resolve(row as { count: number });
      });
    });

    const totalCustomersCount = totalCustomers.count;

    const stats: DashboardStats = {
      contactsLastWeek: 0, // Mock for now
      contactsToday: 0, // Mock for now
      salesReps: salesReps.count,
      totalCustomers: totalCustomersCount,
      latePayments: 0, // Mock for now
      latePaymentsPercent: 0,
      unpaidInvoices: 0, // Mock for now
      unpaidInvoicesPercent: 0,
      openQuotes: leadCustomers.count,
      wonQuotes: activeCustomers.count,
      newQuoteRequests: 0, // Mock for now
      updatedQuoteRequests: 0, // Mock for now
      totalProjects: 0, // Mock for now
      openProjects: 0, // Mock for now
      completedProjects: 0, // Mock for now
      inProgressProjects: 0, // Mock for now
      openOpportunities: leadCustomers.count,
      openOpportunitiesPercent: totalCustomersCount > 0 ? Math.round((leadCustomers.count / totalCustomersCount) * 100) : 0
    };

    return NextResponse.json(stats);
  } catch (error) {
    console.error('Error fetching dashboard stats:', error);
    return NextResponse.json({ error: 'Failed to fetch dashboard stats' }, { status: 500 });
  }
}