import { NextRequest, NextResponse } from 'next/server';
import { getCurrentUser } from '@/src/lib/auth';
import { initAuthDatabase } from '@/src/lib/db-auth';

export async function GET(request: NextRequest) {
    try {
        // Initialize auth database
        await initAuthDatabase();

        // Get current user from token
        const user = await getCurrentUser(request);

        if (!user) {
            return NextResponse.json(
                { error: 'לא מחובר' },
                { status: 401 }
            );
        }

        return NextResponse.json({ user });
    } catch (error) {
        console.error('Get current user error:', error);
        return NextResponse.json(
            { error: 'שגיאה פנימית בשרת' },
            { status: 500 }
        );
    }
}
