import { NextResponse } from 'next/server';
import { clearAuthCookie } from '@/src/lib/auth';

export async function POST() {
    try {
        const response = NextResponse.json({
            message: 'התנתקות בוצעה בהצלחה',
        });

        // Clear auth cookie
        clearAuthCookie(response);

        return response;
    } catch (error) {
        console.error('Logout error:', error);
        return NextResponse.json(
            { error: 'שגיאה בהתנתקות' },
            { status: 500 }
        );
    }
}
